// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "main.h"
#include "memcard.h"
#include "stringCommons.h"
#include <fstream>

#define BASE_BOUND { base &= 0xFFFFFFFC;\
	if(base > (0x01800000 - size*4) && base < 0x80000000)\
	base = 0x80000000;\
	else if(base > (0x81800000 - size*4) && base < 0xC0000000)\
	base = 0xC0000000;\
	else if(base > (0xC1800000 - size*4) && base < 0xCC000000)\
	base = 0xCC000000;\
	else if(base > (0xCC010000 - size*4))\
	base = 0xCC010000 - size*4;\
}

int CALLBACK DegubberProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	if(g::degub_msg) {
		DEGUB("DegubberMessage:%s. wParam=0x%08X. lParam=0x%08X.\n",
			TranslateWM(uMsg).c_str(), wParam, lParam);
	}
	DRAWITEMSTRUCT *dis;
	static HFONT hfontCourierNew = NULL;
	static DWORD base=0x80003100;
	static DWORD size;
	RECT rcl;
#define ITEM_HEIGHT 16
	//static int selected = -1;
	bool b = false;
	ostringstream str;

	switch(uMsg) {
	case WM_INITDIALOG:
		GLE(GetClientRect(GetDlgItem(hDlg, IDC_LIST1), &rcl));
		size = rcl.bottom / ITEM_HEIGHT;
		GLE(hfontCourierNew = CreateFont(-12, 0, 0, 0, 0, false, false, false,
			ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
			FIXED_PITCH | FF_MODERN, "Courier New"));
		//SendDlgItemMessage(hDlg, IDC_LIST1, WM_SETFONT, 0, (LPARAM)hfontCourierNew);
		/*if(g_capp.getCPU()) for(DWORD a=base; a<base + size*4; a+=4) {
		int i;
		sprintf(buffer, "%08X  %n", a, &i);
		g_capp.getCPU()->getdasm(a, buffer + i);
		SendDlgItemMessage(hDlg, IDC_LIST1, LB_ADDSTRING, 0, (LPARAM)buffer);
		}*/
		for(DWORD a=base; a<base + size*4; a+=4) {
			SendDlgItemMessage(hDlg, IDC_LIST1, LB_ADDSTRING, 0, (LPARAM)"");
		}
		SendDlgItemMessage(hDlg, IDC_LIST1, LB_SETCURSEL, 0, 0);
		SendDlgItemMessage(hDlg, IDC_EDIT3, EM_LIMITTEXT, 8, 0);
		str << HEX0x08(base);
		GLE(SetDlgItemText(hDlg, IDC_EDIT3, str.str().c_str()));
		break;
	case WM_VKEYTOITEM:
		if(HIWORD(wParam) == 0 && LOWORD(wParam) == VK_UP) {
			base -= 4;
			b = true;
		} else if(HIWORD(wParam) == size-1 && LOWORD(wParam) == VK_DOWN) {
			base += 4;
			b = true;
		} else if(HIWORD(wParam) == 0 && LOWORD(wParam) == VK_PRIOR) {
			base -= size*4;
			b = true;
		} else if(HIWORD(wParam) == size-1 && LOWORD(wParam) == VK_NEXT) {
			base += size*4;
			b = true;
		}
		BASE_BOUND;

		if(b) {
			str << HEX0x08(base);
			SetDlgItemText(hDlg, IDC_EDIT3, str.str().c_str());
			GLE(InvalidateRect((HWND)lParam, NULL, true));
			return -2;
		} else
			return -1;
	case WM_DRAWITEM:
		dis = (DRAWITEMSTRUCT *)lParam;
		if(g_capp.getCPU() &&
			(dis->itemAction == ODA_DRAWENTIRE || dis->itemAction == ODA_SELECT)) {
				DWORD address = base + dis->itemID * 4;

				try {
					str << "  " << HEX0x08(base) << "  " <<
						g_capp.getCPU()->getdasma(address);
				} catch(interp_fatal_exception &e) {
					string s = string("Unhandled exception: ") + e.what();
					DEGUB(s.c_str());
					GLE(MessageBox(hDlg, s.c_str(), APP_NAME, MB_ICONEXCLAMATION));
				}

				GLE(SelectObject(dis->hDC, hfontCourierNew));
				RECT rcl = dis->rcItem;
				rcl.top++;
				rcl.left++;
				rcl.bottom--;
				rcl.right--;
				string s = str.str();
				GLE(DrawText(dis->hDC, s.c_str(), s.length(), &rcl, DT_EXPANDTABS));
				if((dis->itemState & ODS_SELECTED) ||
					(dis->itemAction == ODA_SELECT && !(dis->itemState & ODS_SELECTED))) {
						GLE(DrawFocusRect(dis->hDC, &dis->rcItem));
				}
		}
		break;  //return DefWindowProc(hDlg, uMsg, wParam, lParam);
	case WM_COMMAND:
		if(HIWORD(wParam) == STN_CLICKED) {
			switch(LOWORD(wParam)) {
			case IDCANCEL:
				GLE(PostMessage(GetParent(hDlg), LM_DEGUBBERCLOSED, 0, 0));
				GLE(DestroyWindow(hDlg));
				GLE(DeleteObject(hfontCourierNew));
				break;
				/*case IDOK:
				if(GetFocus() == GetDlgItem(hDlg, IDC_EDIT3)) {
				DWORD d;
				int i;
				GLE(GetDlgItemText(hDlg, IDC_EDIT3, buffer, sizeof(buffer)));
				if(sscanf(buffer, "%X%n", &d, &i) == 1) {
				base = d;
				BASE_BOUND;
				GLE(InvalidateRect(GetDlgItem(hDlg, IDC_LIST1), NULL, true));
				}
				sprintf(buffer, "%08X", base);
				GLE(SetDlgItemText(hDlg, IDC_EDIT3, buffer));
				} else if(GetFocus() == GetDlgItem(hDlg, IDC_EDIT1)) {
				GLE(GetDlgItemText(hDlg, IDC_EDIT1, buffer, sizeof(buffer)));
				}
				break;*/
			}
		}
		break;
	default:
		return false;
	}

	return true;
}


#define AO_BOOL_MAP(macro) \
	macro(g::recompiler, IDC_RECOMPILER)\
	macro(g::rec_disasm, IDC_RECD)\
	macro(g::cache_enabled, IDC_CACHE)\
	macro(g::advanced_mode, IDC_AMODE)\
	macro(g::log_interrupts, IDC_LINT)\
	macro(g::degub_run, IDC_DEGUB)\
	macro(g::lowmem_log, IDC_LOWMEM)\
	macro(g::bouehr, IDC_BOUEHR)\
	macro(g::dumpmem, IDC_DUMPMEM)\
	macro(g::dump_audio, IDC_DUMPAUDIO)\
	macro(g::autopause, IDC_AUTOPAUSE)\
	macro(g::gp_dtex, IDC_DTEX)\
	macro(g::gp_dtexraw, IDC_DTEXRAW)\
	macro(g::log_audio, IDC_LAUDIO)\
	macro(g::iloop, IDC_ILOOP)\
	macro(g::beep, IDC_BEEP)\
	macro(g::software_yuyv, IDC_SOFTYUYV)\
	macro(g::open_edo_on_load, IDC_OPEN_EDO)\
	macro(g::gp_log, IDC_GP_LOG)\
	macro(g::edo_osr, IDC_EDO_OSR)\
	macro(g::use_mdvd, IDC_MDVD)\
	macro(g::bba_log, IDC_LOGBBA)\
	macro(g::exi_log, IDC_LOGEXI)\
	macro(g::memcard_log, IDC_LOGMEMCARDS)\
	macro(g::si_log, IDC_LOGSI)\
	macro(g::dsp_log, IDC_DSPLOG)\
	macro(g::gp_pixelshader, IDC_ENABLE_PS)\
	macro(g::rename_degub, IDC_RENAME)\
	macro(g::degub_on, IDC_DEGUB_ON)\
	macro(g::nerf_sc, IDC_NERF_SC)\
	macro(g::dvd_log, IDC_DVDLOG)\
	macro(g::gp_dlrec, IDC_ENABLE_DLREC)\
	macro(g::separate_emudebug_file, IDC_SEF)\

#define AO_IP_MAP(macro) \
	macro(g::ip_dst_old, IDC_IP_OUT_OLD)\
	macro(g::ip_dst_new, IDC_IP_OUT_NEW)\

#define AO_UINT_MAP(macro) \
	macro(g::degub_skip, IDC_DEGUB_SKIP)\
	macro(g::audio_buffer_min_size_ms, IDC_ADBUFSIZE)\

#define AO_STRING_MAP(macro) \
	macro(g::mdvd_filename, IDC_MDVD_FILE)\

static const int s_tm_values[] = { g::TM_REALTIME, g::TM_EXACT_REAL, g::TM_EXACT_FAST };
static const int s_tm_ids[] = { IDC_REALTIME, IDC_EXACT_REAL, IDC_EXACT_FAST };

#define AO_ENUM_MAP(macro) \
	macro(g::timing_mode, g::_TM_NMODES, s_tm_values, s_tm_ids)

#define AO_GRAY_MAP(macro) \
	macro(IDC_RECOMPILER, IDC_RECD)\
	macro(IDC_DEGUB, IDC_S_DEGUB_SKIP)\
	macro(IDC_DEGUB, IDC_DEGUB_SKIP)\
	macro(IDC_MDVD, IDC_MDVD_FILE)\
	macro(IDC_MDVD, IDC_MDVD_BROWSE)\
	macro(IDC_DEGUB_ON, IDC_RENAME)\
	macro(IDC_DEGUB_ON, IDC_DEGUB)\
	macro(IDC_DEGUB_ON, IDC_S_DEGUB_SKIP)\
	macro(IDC_DEGUB_ON, IDC_DEGUB_SKIP)\
	macro(IDC_DEGUB_ON, IDC_BEEP)\
	macro(IDC_DEGUB_ON, IDC_GP_LOG)\
	macro(IDC_DEGUB_ON, IDC_LAUDIO)\
	macro(IDC_DEGUB_ON, IDC_DSPLOG)\
	macro(IDC_DEGUB_ON, IDC_LINT)\
	macro(IDC_DEGUB_ON, IDC_LOWMEM)\
	macro(IDC_DEGUB_ON, IDC_LOGEXI)\
	macro(IDC_DEGUB_ON, IDC_LOGBBA)\
	macro(IDC_DEGUB_ON, IDC_LOGMEMCARDS)\
	macro(IDC_DEGUB_ON, IDC_LOGSI)\
	macro(IDC_DEGUB_ON, IDC_BOUEHR)\
	macro(IDC_DEGUB_ON, IDC_DVDLOG)\

#define AO_DO_GRAY(checkbox, control) EnableWindow(GetDlgItem(hDlg, control),\
	IsDlgButtonChecked(hDlg, checkbox) == BST_CHECKED);

void AOSetGrayness(HWND hDlg) {
	EnableWindow(GetDlgItem(hDlg, IDC_CACHE),
		IsDlgButtonChecked(hDlg, IDC_AMODE) != BST_CHECKED);

	AO_GRAY_MAP(AO_DO_GRAY);

	if(IsDlgButtonChecked(hDlg, IDC_AMODE) == BST_CHECKED) {
		GLE(CheckDlgButton(hDlg, IDC_CACHE, BST_UNCHECKED));
	}
}

bool AOEnumInit(int value, int num, const int *ea, const int *ia, HWND hDlg) {
	bool valid = false;
	for(int i=0; i<num; i++) if(value == ea[i]) {
		TGLE(CheckDlgButton(hDlg, ia[i], BST_CHECKED));
		valid = true;
		break;
	}
	if(!valid) {
		//throw ui_exception("Internal error: AOEnumInit");
		FAIL(UE_GENERIC_ERROR);
	}
	return true;
}
bool AOEnumSave(void *value, int num, const int *ea, const int *ia, HWND hDlg) {
	bool valid = false;
	for(int i=0; i<num; i++) if(IsDlgButtonChecked(hDlg, ia[i]) == BST_CHECKED) {
		*(int*)value = ea[i];
		valid = !valid;
		if(!valid)
			break;
	}
	if(!valid) {
		//throw ui_exception("Internal error: AOEnumSave");
		FAIL(UE_GENERIC_ERROR);
	}
	return true;
}

int CALLBACK AOptionsProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	if(g::degub_msg) {
		DEGUB("AOptionsMessage:%s. wParam=0x%08X. lParam=0x%08X.\n",
			TranslateWM(uMsg).c_str(), wParam, lParam);
	}

	switch(uMsg) {
	case WM_INITDIALOG:
#define AO_IP_INIT(b, id) SendDlgItemMessage(hDlg, id, IPM_SETADDRESS, 0, (b));
		AO_IP_MAP(AO_IP_INIT);
#define AO_UINT_INIT(b, id) R0GLE(SetDlgItemInt(hDlg, id, (b), false));
		AO_UINT_MAP(AO_UINT_INIT);

#define AO_BOOL_INIT(b, id)\
	R0GLE(CheckDlgButton(hDlg, id, (b) ? BST_CHECKED : BST_UNCHECKED));
		AO_BOOL_MAP(AO_BOOL_INIT);
		R0GLE(CheckDlgButton(hDlg, IDC_INTERPRETER,
			(!g::recompiler) ? BST_CHECKED : BST_UNCHECKED));

#define AO_STRING_INIT(b, id) R0GLE(SetDlgItemText(hDlg, id, (b).c_str()));
		AO_STRING_MAP(AO_STRING_INIT);
#define AO_ENUM_INIT(b, num, values, ids) R0GLE(AOEnumInit(b, num, values, ids, hDlg));
		AO_ENUM_MAP(AO_ENUM_INIT);

		AOSetGrayness(hDlg);
		break;
	case WM_COMMAND:
		AOSetGrayness(hDlg);
		if(HIWORD(wParam) == STN_CLICKED) {
			switch(LOWORD(wParam)) {
			case IDC_MDVD_BROWSE:
				{
					string s;
					if(MyGetOpenFileName(hDlg, s, "Select GCM", FILTER_GCM)) {
						GLE(SetDlgItemText(hDlg, IDC_MDVD_FILE, s.c_str()));
					}
				}
				break;
			case IDOK:
				//Check validity of values (MAC address, vdvd root).
				//If all's ok, save them to teh global variables and close dialog.
				//Otherwise, show an appropriate error message.

				if(IsDlgButtonChecked(hDlg, IDC_MDVD) == BST_CHECKED) {
					string s;
					R0GLE(GetDlgItemText(hDlg, IDC_MDVD_FILE, s));
					ifstream file(s.c_str());
					if(!file.good()) {
						string msg = "The file \"" + s + "\" cannot be opened. "
							"Pick another one, will you? :)";
						MessageBox(hDlg, msg.c_str(), "Hold on there!", MB_ICONHAND);
						break;
					}
				}

#define AO_BOOL_SAVE(b, id) (b) = IsDlgButtonChecked(hDlg, id) == BST_CHECKED;
				AO_BOOL_MAP(AO_BOOL_SAVE);
#define AO_UINT_SAVE(b, id) (b) = GetDlgItemInt(hDlg, id, NULL, false);
				AO_UINT_MAP(AO_UINT_SAVE);
#define AO_IP_SAVE(b, id) SendDlgItemMessage(hDlg, id, IPM_GETADDRESS, 0, (LPARAM)&(b));
				AO_IP_MAP(AO_IP_SAVE);
#define AO_STRING_SAVE(b, id) { char buffer[MAX_PATH];\
	GetDlgItemText(hDlg, id, buffer, sizeof(buffer)); (b) = buffer; }
				AO_STRING_MAP(AO_STRING_SAVE);
#define AO_ENUM_SAVE(b, num, values, ids)\
	R0GLE(AOEnumSave(&b, num, values, ids, hDlg));
				AO_ENUM_MAP(AO_ENUM_SAVE);

				final_overrides();

				GLE(g_ini.WriteIniFile());
			case IDCANCEL:
				GLE(EndDialog(hDlg, LOWORD(wParam)));
				break;
			}
		}
		break;
	default:
		return false;
	}

	return true;
}

#define PAD_ID_MAP(macro) \
	macro(a, A)\
	macro(b, B)\
	macro(x, X)\
	macro(y, Y)\
	macro(z, Z)\
	macro(start, START)\
	macro(l, L)\
	macro(r, R)\
	macro(aup, AUP)\
	macro(aleft, ALEFT)\
	macro(adown, ADOWN)\
	macro(aright, ARIGHT)\
	macro(dup, DUP)\
	macro(dleft, DLEFT)\
	macro(ddown, DDOWN)\
	macro(dright, DRIGHT)\
	macro(cup, CUP)\
	macro(cleft, CLEFT)\
	macro(cdown, CDOWN)\
	macro(cright, CRIGHT)\

#define FOUR(macro) macro(0) macro(1) macro(2) macro(3)

void PadsSetGrayness(HWND hDlg) {
	bool enabled=false; //this default value should not be needed
#define SET_ENABLED(num) if(TabCtrl_GetCurSel(GetDlgItem(hDlg, IDC_TAB)) == num)\
	enabled = IsDlgButtonChecked(hDlg, IDC_PADON##num) == BST_CHECKED;

	FOUR(SET_ENABLED);

#define PAD_BUTTON_GRAY(lower, upper) \
	EnableWindow(GetDlgItem(hDlg, IDC_##upper), enabled);

	PAD_ID_MAP(PAD_BUTTON_GRAY);
}

HRESULT SetBufferSize(LPDIRECTINPUTDEVICE pdiDevice, DWORD size) {
	DIPROPDWORD dipdw;
	dipdw.diph.dwSize       = sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw.diph.dwObj        = 0;
	dipdw.diph.dwHow        = DIPH_DEVICE;
	dipdw.dwData            = size; // Arbitary buffer size
	THR(pdiDevice->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph));
	return S_OK;
}

void SetButtonText(LPDIRECTINPUTDEVICE pdiDevice, HWND hDlg, int nIDDlgItem, DWORD dwOfs)
{
	string s;
	if(dwOfs == 0) {
		s = "...";
	} else {
		DIDEVICEOBJECTINSTANCE didoi;
		didoi.dwSize = sizeof(DIDEVICEOBJECTINSTANCE);
		HR(pdiDevice->GetObjectInfo(&didoi, dwOfs, DIPH_BYOFFSET));
		s = didoi.tszName;
	}
	GLE(SetDlgItemText(hDlg, nIDDlgItem, s.c_str()));
}

void SetButtonsText(LPDIRECTINPUTDEVICE pdiDevice, HWND hDlg, PAD_SCANCODES sc) {
#define SET_BUTTON_TEXT(lower, upper) \
	SetButtonText(pdiDevice, hDlg, IDC_##upper, sc.lower);

	PAD_ID_MAP(SET_BUTTON_TEXT);
}

#define SAMPLE_BUFFER_SIZE 8

int CALLBACK PadsProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	static PAD_SCANCODES temp_sc[PAD_NPADS];
	static BYTE temp_half, temp_quarter, temp_reset_button;
	static LPDIRECTINPUTDEVICE pdiDevice;

	//static WORD waiting_for_keypress;

	if(g::degub_msg) {
		DEGUB("PadsMessage:%s. wParam=0x%08X. lParam=0x%08X.\n",
			TranslateWM(uMsg).c_str(), wParam, lParam);
	}

	switch(uMsg) {
	case WM_INITDIALOG:
		memcpy(temp_sc, g::pad_sc, sizeof(temp_sc));
		temp_half = g::pad_half;
		temp_quarter = g::pad_quarter;
		temp_reset_button = g::reset_button;
		pdiDevice = g_capp.getDIDevice();

		//waiting_for_keypress = 0;

		for(int i=0; i<PAD_NPADS; i++) {
			MYASSERT(i < 9);
			string s = STRING_PLUS_DIGIT("Pad ", i);
			const TCITEM tci = { TCIF_TEXT, 0, 0, (char*)s.c_str(), 0, 0 };
			TabCtrl_InsertItem(GetDlgItem(hDlg, IDC_TAB), i, &tci);
		}
		TabCtrl_SetCurSel(GetDlgItem(hDlg, IDC_TAB), 0);

#define PAD_ON_INIT(num) \
	R0GLE(CheckDlgButton(hDlg, IDC_PADON##num,\
	(g::pad_on[num]) ? BST_CHECKED : BST_UNCHECKED));

		FOUR(PAD_ON_INIT);

		SetButtonsText(pdiDevice, hDlg, temp_sc[0]);
		SetButtonText(pdiDevice, hDlg, IDC_HALF, temp_half);
		SetButtonText(pdiDevice, hDlg, IDC_QUARTER, temp_quarter);
		SetButtonText(pdiDevice, hDlg, IDC_RESET_BUTTON, temp_reset_button);

		PadsSetGrayness(hDlg);
		break;
	case WM_NOTIFY:
		{
			LPNMHDR lpnmhdr = (LPNMHDR)lParam;
			if(lpnmhdr->code == TCN_SELCHANGE && lpnmhdr->idFrom == IDC_TAB) {
				SetButtonsText(pdiDevice, hDlg,
					temp_sc[TabCtrl_GetCurSel(GetDlgItem(hDlg, IDC_TAB))]);
				PadsSetGrayness(hDlg);
			}
		}
		break;
	case WM_COMMAND:
		PadsSetGrayness(hDlg);
		if(HIWORD(wParam) == STN_CLICKED) {
			WORD waiting_for_keypress;
			switch(LOWORD(wParam)) {
#define PAD_ON_CASE(num) case IDC_PADON##num:\
	if(IsDlgButtonChecked(hDlg, IDC_PADON##num) == BST_CHECKED) {\
	TabCtrl_SetCurSel(GetDlgItem(hDlg, IDC_TAB), num);\
	SetButtonsText(pdiDevice, hDlg, temp_sc[num]);\
	PadsSetGrayness(hDlg); } break;
				FOUR(PAD_ON_CASE);
			case IDC_HALF:
			case IDC_QUARTER:
			case IDC_RESET_BUTTON:
#define PAD_BUTTON_CASE(lower, upper) case IDC_##upper:
				PAD_ID_MAP(PAD_BUTTON_CASE);

				GLE(SetDlgItemText(hDlg, LOWORD(wParam), "???"));
				pdiDevice->Unacquire();
				R0HR(pdiDevice->SetCooperativeLevel(hDlg, DISCL_EXCLUSIVE | DISCL_FOREGROUND));
				R0HR(SetBufferSize(pdiDevice, 0));
				R0HR(SetBufferSize(pdiDevice, DIK_BUFFER_SIZE));
				R0HR(pdiDevice->Acquire());
				waiting_for_keypress = LOWORD(wParam);
				while(waiting_for_keypress) {
					DIDEVICEOBJECTDATA didod[SAMPLE_BUFFER_SIZE];
					DWORD dwElements = SAMPLE_BUFFER_SIZE;
					R0HR(pdiDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), didod,
						&dwElements, 0));

					for(DWORD i=0; i<dwElements; i++) if(didod[i].dwData & 0x80) {
						SetButtonText(pdiDevice, hDlg, waiting_for_keypress, didod[i].dwOfs);
						MYASSERT(didod[i].dwOfs < 256);

						switch(waiting_for_keypress) {
						case IDC_HALF:
							temp_half = (BYTE)didod[i].dwOfs;
							waiting_for_keypress = 0;
							break;
						case IDC_QUARTER:
							temp_quarter = (BYTE)didod[i].dwOfs;
							waiting_for_keypress = 0;
							break;
						case IDC_RESET_BUTTON:
							temp_reset_button = (BYTE)didod[i].dwOfs;
							waiting_for_keypress = 0;
							break;
#define PAD_TEMP_ASSIGN(lower, upper) case IDC_##upper:\
	temp_sc[TabCtrl_GetCurSel(GetDlgItem(hDlg, IDC_TAB))].lower = (BYTE)didod[i].dwOfs;\
	waiting_for_keypress = 0; break;

							PAD_ID_MAP(PAD_TEMP_ASSIGN);
						default:
							MYASSERT(false);
						}
						if(!waiting_for_keypress)
							break;
						else
							Sleep(1);
					}
				}
				pdiDevice->Unacquire();
				R0HR(pdiDevice->SetCooperativeLevel(hDlg, DISCL_NONEXCLUSIVE | DISCL_BACKGROUND));
				R0HR(SetBufferSize(pdiDevice, 0));
				R0HR(SetBufferSize(pdiDevice, DIK_BUFFER_SIZE));
				break;
			case IDOK:
				//Check validity of values.
				//If all's ok, save them to teh global variables and close dialog.
				//Otherwise, show an appropriate error message.
				for(UINT b=1; b<256; b++) {
					int mappings=0;
					if(temp_half == b) mappings++;
					if(temp_quarter == b) mappings++;
					if(temp_reset_button == b) mappings++;
#define PAD_TEMP_MAPPING_CHECK(lower, upper) if(temp->lower == b) mappings++;
#define PAD_TEMP_MAPPINGS_CHECK(num)\
	if(IsDlgButtonChecked(hDlg, IDC_PADON##num) == BST_CHECKED) {\
	PAD_SCANCODES *temp = &temp_sc[num]; PAD_ID_MAP(PAD_TEMP_MAPPING_CHECK); }
					FOUR(PAD_TEMP_MAPPINGS_CHECK);

					if(mappings > 1) {
						DIDEVICEOBJECTINSTANCE didoi;
						didoi.dwSize = sizeof(DIDEVICEOBJECTINSTANCE);
						HR(pdiDevice->GetObjectInfo(&didoi, b, DIPH_BYOFFSET));

						ostringstream str;
						str << "The " << didoi.tszName << " key is mapped to " <<
							mappings << " active buttons. Are you sure it should be?";
						int res = MessageBox(hDlg, str.str().c_str(), APP_NAME,
							MB_YESNO | MB_DEFBUTTON2 | MB_ICONQUESTION);
						R0GLE(res);
						if(res == IDNO)
							return false;
					}
				}

#define PAD_ON_SAVE(num) g::pad_on[num] =\
	IsDlgButtonChecked(hDlg, IDC_PADON##num) == BST_CHECKED;

				FOUR(PAD_ON_SAVE);

				memcpy(g::pad_sc, temp_sc, sizeof(temp_sc));
				g::pad_half = temp_half;
				g::pad_quarter = temp_quarter;
				g::reset_button = temp_reset_button;
				//Save to INI
				GLE(g_ini.WriteIniFile());
			case IDCANCEL:
				GLE(EndDialog(hDlg, LOWORD(wParam)));
				break;
			}
		}
		break;
	default:
		return false;
	}
	return true;
}

/*int CALLBACK OSRWordBreakProc(LPTSTR lpch, int ichCurrent, int cch, int code) {
DEGUB("WordBreak: ");
switch(code) {
/*case WB_CLASSIFY:
DEGUB("WB_CLASSIFY\n");
break;
case WB_ISDELIMITER:
DEGUB("WB_ISDELIMITER\n");
break;
case WB_LEFT:
DEGUB("WB_LEFT\n");
break;
case WB_LEFTBREAK:
DEGUB("WB_LEFTBREAK\n");
break;
case WB_MOVEWORDLEFT:
DEGUB("WB_MOVEWORDLEFT\n");
break;
case WB_MOVEWORDRIGHT:
DEGUB("WB_MOVEWORDRIGHT\n");
break;
case WB_RIGHT:
DEGUB("WB_RIGHT\n");
break;
case WB_RIGHTBREAK:
DEGUB("WB_RIGHTBREAK\n");
break;
default:
DEGUB("Unknown WordBreak code: %i\n", code);
throw ui_exception("Unknown WordBreak code!");
}
return 0;
}*/

int CALLBACK DebugOutputProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	if(g::degub_msg) {
		DEGUB("DebugOutputMessage:%s. wParam=0x%08X. lParam=0x%08X.\n",
			TranslateWM(uMsg).c_str(), wParam, lParam);
	}
	static HFONT hfontCourierNew = NULL;

	switch(uMsg) {
	case WM_INITDIALOG:
		GLE(hfontCourierNew = CreateFont(-12, 0, 0, 0, 0, false, false, false,
			ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
			FIXED_PITCH | FF_MODERN, "Courier New"));
		SendDlgItemMessage(hDlg, IDC_EDO_EDIT, WM_SETFONT, (WPARAM)hfontCourierNew, FALSE);
		//SendDlgItemMessage(hDlg, IDC_EDO_EDIT, WM_SETTEXT, 0, (LPARAM)"TestText");
		SendDlgItemMessage(hDlg, IDC_EDO_EDIT, EM_LIMITTEXT, (WPARAM)-1, 0);
		//SendDlgItemMessage(hDlg, IDC_EDO_EDIT, EM_SETWORDBREAKPROC, 0,
		//(LPARAM)OSRWordBreakProc);
		break;
	case LM_LOAD:
		SendDlgItemMessage(hDlg, IDC_EDO_EDIT, WM_SETTEXT, 0, (LPARAM)"");
		break;
	case LM_DEBUG:
		if(wParam == EDO_ADD) {
			HWND hEdit = GetDlgItem(hDlg, IDC_EDO_EDIT);
			DWORD selStart, selStop;
			SendMessage(hEdit, EM_GETSEL, (WPARAM)&selStart, (LPARAM)&selStop);
			size_t wtl = GetWindowTextLength(hEdit);
			SendMessage(hEdit, EM_SETSEL, wtl, wtl);
			SendMessage(hEdit, EM_REPLACESEL, false, lParam);
			SendMessage(hEdit, EM_SETSEL, selStart, selStop);
		} else if(wParam == EDO_REPLACE) {
			SendDlgItemMessage(hDlg, IDC_EDO_EDIT, WM_SETTEXT, 0, lParam);
		} else if(wParam == EDO_CLEAR) {
			SendDlgItemMessage(hDlg, IDC_EDO_EDIT, WM_SETTEXT, 0, (LPARAM)"");
		} else {
			DEGUB("Illegal EDO command: %i\n", wParam);
			throw ui_exception("Internal error: Illegal EDO command!");
		}
		break;
	case WM_CHAR:
		SendDlgItemMessage(hDlg, IDC_EDO_EDIT, uMsg, wParam, lParam);
		break;
	case WM_COMMAND:
		if(HIWORD(wParam) == STN_CLICKED) {
			switch(LOWORD(wParam)) {
			case IDOK:
			case IDCANCEL:
				GLE(PostMessage(GetParent(hDlg), LM_DEBUG_OUTPUT_CLOSED, 0, 0));
				GLE(DestroyWindow(hDlg));
				GLE(DeleteObject(hfontCourierNew));
				break;
			}
		}
		break;
	default:
		return false;
	}

	return true;
}

struct MEH {  //this needs a better name
	int device, caching, file, sfile, create, open, remove;
};
#define MEMCARD_IDCS(macro) macro(DEVICE), macro(CACHING), macro(FILE),\
	macro(SFILE), macro(CREATE), macro(OPEN), macro(REMOVE)

bool SetMCControls(HWND hDlg, const MEH &meh, const MEMCARDSLOT_INFO &memcard_info) {
	bool enabled = memcard_info.content != MSC_Empty;
	TGLE(SetDlgItemText(hDlg, meh.device, str_MSC_long[memcard_info.content]));
	TGLE(CheckDlgButton(hDlg, meh.caching,
		memcard_info.caching ? BST_CHECKED : BST_UNCHECKED));
	TGLE(SetDlgItemText(hDlg, meh.file, memcard_info.filename.c_str()));

#define MEMCARD_DISABLABLE_IDS(macro) macro(caching) macro(file)\
	macro(sfile) macro(remove)
#define CHECK_ID(id) if(!GetDlgItem(hDlg, meh.id)) { DoGLE(); DEGUB("%s\n", #id); }
	MEMCARD_DISABLABLE_IDS(CHECK_ID);
#define ENABLE_CONTROL(id) EnableWindow(GetDlgItem(hDlg, meh.id), enabled);
	MEMCARD_DISABLABLE_IDS(ENABLE_CONTROL);

	return true;
}

int CALLBACK MemcardsProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	static MEMCARDSLOT_INFO memcard_info[2];
	if(g::degub_msg) {
		DEGUB("MemcardsMessage:%s. wParam=0x%08X. lParam=0x%08X.\n",
			TranslateWM(uMsg).c_str(), wParam, lParam);
	}

#define DO_MCIDC1(idc) IDC_##idc##1
#define DO_MCIDC2(idc) IDC_##idc##2
	MEH meh[2] = {{ MEMCARD_IDCS(DO_MCIDC1) }, { MEMCARD_IDCS(DO_MCIDC2) }};

	switch(uMsg) {
	case WM_INITDIALOG:
		for(int i=0; i<2; i++) {
			memcard_info[i] = g::memcardslot_info[i];
			R0GLE(SetMCControls(hDlg, meh[i], memcard_info[i]));
		}
		break;
	case WM_COMMAND:
		if(HIWORD(wParam) == STN_CLICKED) {
			WORD button_id = LOWORD(wParam);
			if(button_id == IDOK || button_id == IDCANCEL) {
				if(button_id == IDOK) {
					for(int i=0; i<2; i++) {
						g::memcardslot_info[i] = memcard_info[i];
						if(g_capp.getCPU()) {
							Hardware &h = g_capp.getCPU()->getHardware();
							h.updateMemcardSlot(i, memcard_info[i]);
						}
					}
					R0GLE(g_ini.WriteIniFile());
				}
				R0GLE(EndDialog(hDlg, LOWORD(wParam)));
			} else for(int i=0; i<2; i++) {
				if(button_id == meh[i].remove) {
					memcard_info[i].content = MSC_Empty;
					memcard_info[i].filename = "";
					R0GLE(SetMCControls(hDlg, meh[i], memcard_info[i]));
				} else if(button_id == meh[i].create) {
					MEMCARDSLOT_INFO mcsi;
					//open dialog
					int res = DialogBoxParam((HINSTANCE)GetWindowLong(hDlg, GWL_HINSTANCE), 
						MAKEINTRESOURCE(IDD_CREATECARD), hDlg, CreateCardProc, (LPARAM)&mcsi);
					if(res == 0 || res == -1) {
						R0GLE(0);
					}
					//if OK, update shit
					//if cancel, don't
					if(res == IDOK) {
						memcard_info[i] = mcsi;
						R0GLE(SetMCControls(hDlg, meh[i], memcard_info[i]));
					}
				} else if(button_id == meh[i].open) {
					string s;
					if(MyGetOpenFileName(hDlg, s, "Open Memcard Image",
						"Memcard Images (*.mci)\0*.mci"))
					{
						int file_content;
						R0GLE(GetMCFileContent(s.c_str(), file_content));
						memcard_info[i].content = (MemcardSlotContent)file_content;
						if(file_content == MSC_Empty) {
							MessageBox(hDlg, "This file is not a valid memcard image.", "Error",
								MB_ICONSTOP);
							memcard_info[i].filename = "";
						} else {
							memcard_info[i].filename = s.c_str();
						}
						R0GLE(SetMCControls(hDlg, meh[i], memcard_info[i]));
					}
				}
			}
		}
		break;
	default:
		return false;
	}

	return true;
}

int CALLBACK CreateCardProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	if(g::degub_msg) {
		DEGUB("CreateCardMessage:%s. wParam=0x%08X. lParam=0x%08X.\n",
			TranslateWM(uMsg).c_str(), wParam, lParam);
	}
	static MEMCARDSLOT_INFO *mcsip;

	switch(uMsg) {
	case WM_INITDIALOG:
		mcsip = (MEMCARDSLOT_INFO *)lParam;
		mcsip->caching = false;
		EnableWindow(GetDlgItem(hDlg, IDOK), false);
		R0GLE(CheckDlgButton(hDlg, IDC_MC123, BST_CHECKED));
		break;
	case WM_COMMAND:
		if(HIWORD(wParam) == STN_CLICKED) {
			WORD button_id = LOWORD(wParam);
			if(button_id == IDOK || button_id == IDCANCEL) {
				if(button_id == IDOK) {
					char buffer[MAX_PATH];
					R0GLE(GetDlgItemText(hDlg, IDC_FILE, buffer, MAX_PATH));
					mcsip->filename = buffer;
#define DO_THING(id) if(IsDlgButtonChecked(hDlg, IDC_##id) == BST_CHECKED)\
	mcsip->content = MSC_##id;
					MEMCARD_TYPES_NOCOMMA(DO_THING);
				}
				R0GLE(EndDialog(hDlg, LOWORD(wParam)));
			} else if(button_id == IDC_BROWSE) {
				string s;
				if(MyGetSaveFileName(hDlg, s, "Create Memcard Image",
					"Memcard Image (*.mci)\0*.mci", "mci"))
				{
					R0GLE(SetDlgItemText(hDlg, IDC_FILE, s.c_str()));
				}
			}
		} else if(HIWORD(wParam) == EN_UPDATE) {
			WORD control_id = LOWORD(wParam);
			if(control_id == IDC_FILE) {
				EnableWindow(GetDlgItem(hDlg, IDOK), GetWindowTextLength((HWND)lParam) != 0);
			}
		}
		break;
	default:
		return false;
	}

	return true;
}
